/*
 * This file is part of PRO CFW.

 * PRO CFW is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * PRO CFW is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PRO CFW. If not, see <http://www.gnu.org/licenses/ .
 */

#ifndef _MODULE2_H_
#define _MODULE2_H_

// Taken from M33 SDK
#ifndef SceModule2_DEFINED
typedef struct SceModule2
{
    struct SceModule2 * next; // 0
    unsigned short attribute; // 4
    unsigned char version[2]; // 6
    char modname[27]; // 8
    char terminal; // 0x23
    char mod_state;  // 0x24
    char unk1;    // 0x25
    char unk2[2]; // 0x26
    unsigned int unk3; // 0x28
    int modid; // 0x2C
    unsigned int unk4; // 0x30
    int mem_id; // 0x34
    unsigned int mpid_text;  // 0x38
    unsigned int mpid_data; // 0x3C
    void * ent_top; // 0x40
    unsigned int ent_size; // 0x44
    void * stub_top; // 0x48
    unsigned int stub_size; // 0x4C
    unsigned int entry_addr_; // 0x50
    unsigned int unk5[4]; // 0x54
    unsigned int entry_addr; // 0x64
    unsigned int gp_value; // 0x68
    unsigned int text_addr; // 0x6C
    unsigned int text_size; // 0x70
    unsigned int data_size;  // 0x74
    unsigned int bss_size; // 0x78
    unsigned int nsegment; // 0x7C
    unsigned int segmentaddr[4]; // 0x80
    unsigned int segmentsize[4]; // 0x90
} SceModule2;
#define SceModule2_DEFINED
#endif

#endif

